
@echo off
echo =========================================================
echo Uberlogger firmware updater
echo (c) 2024 Tecnion Technologies
echo =========================================================
echo.
echo Steps to update:
echo 1) Connect Uberlogger to USB port on your pc and do NOT use a USB hub in between. Turn on the Uberlogger so that the Uberlogger green LED turns on.
echo 2) Hold the mode button pressed, and briefly press the reset button while holding.
echo    The green LED should turn off. Release all buttons; the green LED should remain off. The logger is now in firmware update mode.
echo 3) Press [ENTER] to start flashing, or enter the COM-port to skip the search.
echo 4) The updater will search for the correct COM-port, and might try them all. Just have some patience.
echo 5) After the updater is done, please manually reset the Uberlogger by pressing the reset button. 
echo.
echo Warning: do not disconnect the module from USB power or from your computer while updating
echo.
echo.

:PRG
set COMPORT=
set /p COMPORT=COM-port of module (leave empty to search):

IF [%COMPORT%] == [] GOTO NOCOM

:COM_DETECTED
echo Updating firmware...
.\esptool.exe --chip esp32s2 --baud 921600 --port %COMPORT% --before usb_reset --after hard_reset write_flash --flash_mode dio --flash_freq 80m --flash_size 4MB 0x0000 .\firmware.bin
GOTO DONE

:NOCOM
echo Searching for COM-port...
set COMPORT=
for /f "usebackq" %%B in (`wmic path Win32_SerialPort Where "PNPDeviceID LIKE '%%VID_303A&PID_1001%%'" Get DeviceID ^| FIND "COM"`) do set COMPORT=%%B
IF [%COMPORT%] == [] GOTO TRYALL

echo COM-port is detected as %COMPORT%
GOTO COM_DETECTED

:TRYALL
echo Automatic detection failed. Trying all COM-ports, this might take a while...
echo.
.\esptool.exe  --chip esp32s2 --baud 921600 --before usb_reset --after no_reset write_flash --flash_mode dio --flash_freq 80m --flash_size 4MB 0x0000 .\firmware.bin


IF ERRORLEVEL 1 GOTO PRGERROR

call soundplayer.bat "C:\Windows\Media\Windows Ding.wav"

:PRGSUCCES
echo.
echo Done. Please manually reset the Uberlogger by pressing the reset button. 
goto DONE

:PRGERROR
echo.
echo ! ! ! Error occured during flasing ! ! !
pause

:DONE
echo.

